"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../../components/footer'
import Header from '../../components/header'
import '../../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../../components/loader';
import Head from 'next/head'
import { useRouter } from 'next/router';




const Home = ()=>{
const [data,setData]=useState()
const [company,setCompany]=useState([])
const [menu,setMenu]=useState([])
const params = useParams()
const [loaded,setLoaded]= useState(false)
const [hasSlider,setHasSlider]=useState(false)
const router = useRouter();



async function getData(params) {
  if (params?.company) {
    const dataResponse = await axios.get('https://pixelfcty.com/api/companies?filters[name][$eq]='+params['company']+'&populate=deep')
    const data = dataResponse.data.data[0]
    setData(data)  
    if (!data) {
      router.push('/404')
    }
    const companyResponse = await axios.get('https://pixelfcty.com/api/projects?populate=deep&filters[companies][name][$eq]='+params.company)
    const companydata = companyResponse.data.data  
    setCompany(companydata)
 
    const menuResponse = await axios.get('https://pixelfcty.com/api/menus?populate=deep&filters[parent]&filters[company][name][$eq]='+params.company)
    const menudata = menuResponse.data.data   
    setMenu(menudata)
    if (data) {
      if (data.attributes.slider.length!==0) {
        setHasSlider(true)
      } else setHasSlider(false)
    }
  }

}

useEffect(() => { 
  getData(params)
}, [params])
useEffect(() => {
  if (menu.length !== 0 && data && company) {
    setLoaded(true)
  }
}, [data,menu,company]);

  return (
    <>
        <Head>
      <title>Aljaber Holding | {params?.company} </title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
            <div className='companyPage'>
      <Header iswhite={hasSlider} menu={menu}/>
      </div>
      <div className="container-fluid p-0 m-0 overflow-hidden">
        <div className="row ">
          <div className="col-sm-12 header-video">
            <div id="carouselExampleIndicators" className="carousel slide">
            <div className="carousel-indicators">

              {data?
                data['attributes']['slider'].map((e,index)=>(
                  <button key={e.id} type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to={index} className="active" aria-current="true" aria-label="Slide 1"></button>
                ))
                :''
              }
              </div>
              <div className="carousel-inner">
                
              {data?
                data['attributes']['slider'].map((e,index)=>(
                  <div key={e.id} className={`carousel-item ${index==0?'active':''}`}>
                  <video src={'https://pixelfcty.com/'+e['media']['data']['attributes']['url']}   muted autoPlay preload='true' loop className="d-block w-100">
                    Your browser does not support the video tag.
                  </video>    
                  </div>                ))
                :''
              }


              </div>
              <button className="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                <span className="carousel-control-prev-icon" aria-hidden="true"></span>
                <span className="visually-hidden">Previous</span>
              </button>
              <button className="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                <span className="carousel-control-next-icon" aria-hidden="true"></span>
                <span className="visually-hidden">Next</span>
              </button>
            </div>

          </div>
        </div>
      </div>
      <div className="container">
        <div className="row  ">
          <div className="col-md-12 ck-content">
            {data ?
              parse(data['attributes']['Body'])
              : ''
            }
          </div>
        </div>
      </div>
      <div className="container home-projects">
        <div className="row">
          {
            company.length!=0?
            company.map(e=>(
              <div key={e.id} className="col-md-4 home-project">
                <Link  href={'/companies/'+data['attributes']['name']+'/projects/'+e['attributes']['name']}>
                  
              <div className="cart">
                <img alt='dd' src={'https://pixelfcty.com'+ e['attributes']['picture']['data']['attributes']['url']} width={200} height={200}></img>
                <h3>{ e['attributes']['name']}</h3>
              </div>
              </Link>
            </div>
             
            )):''
          }


        </div>
      </div>

          <Footer/>
    </main>
        }
        </>
  )
}




export default Home;